/*
 * Decompiled with CFR 0.152.
 */
package jace;

import jace.EmulatorUILogic;
import jace.apple2e.Apple2e;
import jace.core.Computer;
import jace.ui.MainFrame;
import java.awt.Canvas;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class Emulator {
    public static void main(String[] args) {
        Emulator e = new Emulator();
    }

    public Emulator() {
        Apple2e computer = new Apple2e();
        MainFrame theApp = new MainFrame();
        try {
            theApp.setIconImage(ImageIO.read(Emulator.class.getClassLoader().getResourceAsStream("jace/data/woz_figure.gif")));
        }
        catch (IOException ex) {
            Logger.getLogger(Emulator.class.getName()).log(Level.SEVERE, null, ex);
        }
        theApp.setVisible(true);
        theApp.setFocusTraversalKeysEnabled(false);
        theApp.screen.setFocusTraversalKeysEnabled(false);
        theApp.setTitle("Java Apple Computer Emulator");
        Emulator.resizeVideo();
        theApp.addKeyListener(computer.getKeyboard().getListener());
        theApp.screen.addKeyListener(computer.getKeyboard().getListener());
        theApp.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent e) {
                Emulator.resizeVideo();
            }

            public void componentMoved(ComponentEvent e) {
                Emulator.resizeVideo();
            }

            public void componentShown(ComponentEvent e) {
            }

            public void componentHidden(ComponentEvent e) {
            }
        });
        theApp.addWindowListener(new WindowListener(){

            public void windowOpened(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
                try {
                    Computer.getComputer().getVideo().suspend();
                    Computer.getComputer().getCpu().suspend();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                System.exit(0);
            }

            public void windowClosed(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
                Computer.getComputer().getVideo().suspend();
            }

            public void windowDeiconified(WindowEvent e) {
                Computer.getComputer().getVideo().resume();
                Emulator.resizeVideo();
            }

            public void windowActivated(WindowEvent e) {
            }

            public void windowDeactivated(WindowEvent e) {
            }
        });
        EmulatorUILogic.registerDebugger();
        computer.getVideo().setScreen(theApp.screen.getGraphics());
        computer.coldStart();
    }

    public static void resizeVideo() {
        MainFrame window = MainFrame.instance;
        JPanel debugger = MainFrame.instance.debugger;
        Canvas screen = MainFrame.instance.screen;
        screen.setSize(window.getContentPane().getWidth() - debugger.getWidth() + 1, window.getContentPane().getHeight());
        Computer.getComputer().getVideo().setWidth(screen.getWidth());
        Computer.getComputer().getVideo().setHeight(screen.getHeight());
        debugger.revalidate();
        Computer.getComputer().getVideo().markDirty();
        screen.repaint();
    }
}

